@extends('layouts.backend')
@section('mainContent')
<main>
<div class="container-fulid">
    <!-- Breadcrumbs-->
    <ol class="breadcrumb">
      <li class="breadcrumb-item">
        <a class="text-danger" href="{{route('admin')}}">Home</a>
      </li>
      <li class="breadcrumb-item active">Notice</li>
    </ol>


    <!-- DataTables Example -->
    <div class="card mb-3">
      <div class="card-header">
        <i class="fas fa-table"></i> Add Notice
        <a href="{{route('ShowStudentNotice')}}" class="float-right btn btn-sm btn-dark">All Notice</a>
      </div>
      <div class="card-body">
        <div class="table-responsive">

          @if($errors)
            @foreach($errors->all() as $error)
              <p class="text-danger">{{$error}}</p>
            @endforeach
          @endif

          @if(Session::has('success'))
            <p class="text-success">{{session('success')}}</p>
          @endif

          <form method="post" action="{{route('StoreStudentNotice')}}" enctype="multipart/form-data">
            @csrf
            <table class="table table-bordered">

                <tr>
                    <th>Date<span class="text-danger">*</span></th>
                    <td>
                      <input type="date" class="form-control" name="date" >
                    </td>
                </tr>
                <tr>
                    <th>Notice<span class="text-danger">*</span></th>
                    <td>
                      <textarea name="notice" cols="30" rows="5" class="form-control" placeholder="What's your noitce?"></textarea>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <input type="submit" class="btn btn-dark" value="Add Notice"/>
                    </td>
                </tr>

            </table>
          </form>
        </div>
      </div>
    </div>
</div>
<main>
@endsection

