<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use BotMan\BotMan\BotMan;
use BotMan\BotMan\Messages\Incoming\Answer;

class BotmanController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function handle()
    {
        $botman = app('botman');
        $botman->hears('{message}', function ($botman, $message){
            if($message == 'hi'){
                $this->askName($botman);
            }else{
                $botman->replay("say hello...");
            }
        });
        $botman->listen();
    }

    // place your botman logic here

    public function askName($botman){
        $botman->ask('Hello! What is your name?', function (Answer $answer){
            $name = $answer->getText();
            $this->say('nice to meet you'.$name);
        });
    }


}
